#include "msx.h"
#include "msxvideo.h"
#include "msxaudio.h"
#include "msxutil.h"
#include "starship.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void menu_initial(int *big, int* spd, int* nrg, int* points1, int* points2);
void main_setup_sprites(int options_big);
void main_sound_setup(char channel, int length, char noise_pitch);
void main_sound_explosion(char channel);
void main_draw_life(char life1, char life2);
void main_print_points(int points1, int points2);

void main(void){

	starship s1, s2; // starships for player 1 and 2
	int points1=0, points2=0; // points (battles won)
	int fired1=0,  fired2=0;  // status flags to prevent autofire
	int dir1=0, dir2=0;       // joystick directions
	int explosion1=0, explosion2=0; // hit count during a single game step
	int options_big=SPRITE_NO_ZOOM, options_spd=0, options_nrg=0;
	int i;

	starship_mem_alloc(&s1);
	starship_mem_alloc(&s2);

	screen1_setup_mode();
	poke(0xF3B0, 32); // set 32 columns per line

	screen_color(15, 1, 1);
	cls();

	screen1_setup_chars();

	main_sound_setup(0,8000,15);
	main_sound_setup(1,8000,15);

	main_setup_sprites(options_big);
  
	while(1){

		main_sound_explosion(0);
		for (i=0;i<32;i++){ screen1_sprite_put(i,0,0,0); }

		/* print total score (battles won by starship) */
		main_print_points(points1, points2);

		/* show main menu */
		menu_initial(&options_big,&options_spd,&options_nrg, &points1, &points2);

		/* options values have been set, game should start now,
		   so go for setup */
		main_setup_sprites(options_big);
		starship_setup(&s1, 128,     40 , 0, 255,  1*8-1, 11*8+2, options_nrg, 2, 14, options_big, options_spd);
		starship_setup(&s2, 128, 192-40 , 0, 255, 13*8-2, 23*8+1, options_nrg, 0,  4, options_big, options_spd);

		cls();
		screen1_setup_back();

		main_draw_life(s1.life, s2.life); // draw yellow balls (life)

		while ( s1.life>0 && s2.life>0 && !is_ctrl_break() ) {
		  if (!fired1 && joytrig(1)) { starship_shoot(&s1,options_spd+2); fired1=1; }
		  if (!fired2 && (joytrig(2)|joytrig(0))) { starship_shoot(&s2,-(options_spd+2)); fired2=1; }
		  if (fired1 && !joytrig(1)){ fired1=0; } // avoid autofire
		  if (fired2 && !(joytrig(2)|joytrig(0))){ fired2=0; } // avoid autofire

		  starship_update(&s1, dir1=joystick(1)); // move starship & bullets one step
		  starship_update(&s2, dir2=(joystick(0)|joystick(2))); // move starship & bullets one step

		  /* if players are moving toghether along X axis, scroll the wall */
		  if ( dir1>=2 && dir1<=4 && dir2>=2 && dir2<=4 ){ screen1_back_rotate( 1); }
		  if ( dir1>=6 && dir1<=8 && dir2>=6 && dir2<=8 ){ screen1_back_rotate(-1); }

		  /* detract life points if hit, and make an explosion sound */
		  if (explosion1=starship_detect_explosion(&s1, &s2)){
			s2.life-=explosion1;
			main_sound_explosion(0);
		  }

		  /* detract life points if hit, and make an explosion sound */
		  if (explosion2=starship_detect_explosion(&s2, &s1)){
			s1.life-=explosion2;
			main_sound_explosion(1);
		  }

		  /* actually redraw sprite positions (note: starship_plot should be
			 rewritten to be as fast as possible) */
		  starship_plot(&s1, 6, 15, 9);
		  starship_plot(&s2, 11, 12, 10);

		  if (explosion1>0 || explosion2>0){
			main_draw_life(s1.life, s2.life); // draw yellow balls (life)
		  }

		}

		/* complicated switch to add a point to the winner (no points
		  if game was a draw) */
		switch(
		  ((s1.life&0x7f)<=0 && (s2.life&0x7f)>0)?
			2 : ( ((s2.life&0x7f)<=0 && (s1.life&0x7f)>0)?1:0 )
		){
		  case 0: break;
		  case 1: points1++; break;
		  case 2: points2++; break;
		}

		cls();
	}
}

void menu_initial(int *big, int* spd, int* nrg, int* points1, int* points2){
  int i,j;
  char s=0;

  const char *msg1a = "Fighters: [small]";
  const char *msg1b = "Fighters: [LARGE]";
  
  const char *msg2a = "Speed: [\310  ]";
  const char *msg2b = "Speed: [\310\310 ]";
  const char *msg2c = "Speed: [\310\310\310]";

  const char *msg3a = "Energy: [\310    ]";
  const char *msg3b = "Energy: [\310\310   ]";
  const char *msg3c = "Energy: [\310\310\310  ]";
  const char *msg3d = "Energy: [\310\310\310\310 ]";
  const char *msg3e = "Energy: [\310\310\310\310\310]";

  const char *msg4  = "Credits / Reset score" ;

  const char *msg5  = "Start game" ;

  const char *msg2[3];
  const char *msg3[5];
  const char *msg[5];

  msg2[0]=msg2a;
  msg2[1]=msg2b;
  msg2[2]=msg2c;
  msg3[0]=msg3a;
  msg3[1]=msg3b;
  msg3[2]=msg3c;
  msg3[3]=msg3d;
  msg3[4]=msg3e;
  msg[0]=(*big)?msg1b:msg1a;
  msg[1]=msg2[*spd];
  msg[2]=msg3[*nrg];
  msg[3]=msg4;
  msg[4]=msg5;
   
  for (i=14;i<=22;i++)
    for (j=2;j<18;j++){
      gotoxy(j,i);
      putchar(160+((j+i)&0x01));
    }
    
  gotoxy(4,15); puts(" Inertial   ");
  gotoxy(4,16); puts(" Navigation ");
  gotoxy(4,17); puts(" Experience ");
  gotoxy(4,18); puts(" Reaction   ");
  gotoxy(4,19); puts(" Test       ");
  gotoxy(4,20); puts(" Inside     ");
  gotoxy(4,21); puts(" Arena      ");
    
  while ((s=text_choice(5, s, "I.N.E.R.T.I.A.", msg)) != 4){
    switch(s){
      case 0:
        *big^=1;
        msg[0]=(big!=NULL && *big!=0)?msg1b:msg1a;
      break;
      case 1:
        *spd=(*spd+1)%3;
        msg[1]=msg2[*spd];
      break;
      case 2:
        *nrg=(*nrg+1)%5;
        msg[2]=msg3[*nrg];        
      break;
      case 3:
        if ((joystick(0)|joystick(1)|joystick(2))==3){
          *points1=0; *points2=0;
          main_print_points(*points1, *points2);
        } else {
          gotoxy(1,1);
          for (i=0;i<32*12;i++){
            putchar( (i<32||i>=32*11)? 160+(i&0x01) : ' ' );
          }
                           //123456789012345678901234567890
          gotoxy(2,2); puts("INERTIA, written in Nov 2006");
          gotoxy(2,3); puts("for MSXDEV contest. Thanks to");
          gotoxy(2,4); puts("MSXITALIA (they keep MSX alive");
          gotoxy(2,5); puts("here in Italy), to friends who");
          gotoxy(2,6); puts("won't laugh about my humble");
          gotoxy(2,7); puts("game, and to my MSX1, still");
          gotoxy(2,8); puts("working fine AFTER 20 YEARS.");          
          gotoxy(2,10); puts("You'll find more MSX stuff at:");
          gotoxy(2,11); puts("http://andrear.altervista.org");
  
          while(!(joytrig(0)|joytrig(1)|joytrig(2))){}
          while(joytrig(0)|joytrig(1)|joytrig(2)){}
  
          gotoxy(1,1);
          for (i=0;i<32*12;i++){ putchar(' '); }
        
        }
        
      break;
    }
  }
}

void main_setup_sprites(int options_big){
  int i;

  char spr_0[]={
    0x01, 0x00, 0x20, 0x00, 0x80, 0x00, 0x00, 0x00,
    0x10, 0x28, 0x44, 0x00, 0x00, 0x01, 0x03, 0x06,
    0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x80, 0xC0
  };
  
  char spr_1[]={
    0x00, 0x01, 0x01, 0x22, 0x22, 0xA4, 0xAA, 0xB9,
    0xED, 0xD6, 0xAA, 0xC7, 0x83, 0x06, 0x0C, 0x08,
    0x00, 0x00, 0x00, 0x88, 0x88, 0x4A, 0xAA, 0x3A,
    0x6E, 0xD6, 0xAA, 0xC6, 0x82, 0xC0, 0x60, 0x20
  };

  char spr_2[]={
    0x06, 0x03, 0x01, 0x00, 0x00, 0x44, 0x28, 0x10,
    0x00, 0x00, 0x00, 0x80, 0x00, 0x20, 0x00, 0x01,
    0xC0, 0x80, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10,
    0x00, 0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00
  };

  char spr_3[]={
    0x08, 0x0C, 0x06, 0x83, 0xC7, 0xAA, 0xD6, 0xED,
    0xB9, 0xAA, 0xA4, 0x22, 0x22, 0x01, 0x01, 0x00,
    0x20, 0x60, 0xC0, 0x82, 0xC6, 0xAA, 0xD6, 0x6E,
    0x3A, 0xAA, 0x4A, 0x88, 0x88, 0x00, 0x00, 0x00
  };

  char spr_4[]={
   0x01, 0x03, 0x03, 0x23, 0x71, 0x71, 0x70, 0x21,
   0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x80, 0x88, 0x1C, 0x1C, 0x1C, 0x08,
   0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00
  };
  
  char spr_5[]={
   0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x21,
   0x70, 0x71, 0x71, 0x23, 0x03, 0x03, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08,
   0x1C, 0x1C, 0x1C, 0x88, 0x80, 0x80, 0x00, 0x00
  };

  char *spr[]={
    spr_0, spr_1,
    spr_2, spr_3,
    spr_4,spr_4,spr_4,spr_4,spr_4,
    spr_4,spr_4,spr_4,spr_4,spr_4,
    spr_5,spr_5,spr_5,spr_5,spr_5,
    spr_5,spr_5,spr_5,spr_5,spr_5,
  };
  
  screen1_setup_sprites(SPRITE16X16,options_big);
  
  for (i=0;i<24;i++){
    screen1_sprite_profile(i, spr[i], SPRITE16X16);
  }
  
}

void main_sound_setup(char channel, int length, char noise_pitch){
  sound_set(2*channel,0);
  sound_set(2*channel+1,0);
  sound_set(6,noise_pitch);
  sound_set(11, length & 0xff);
  sound_set(12, length >> 8);
  sound_set( 7, sound_get(7) & (0xff ^ 1<<(channel+3)) );
}

void main_sound_explosion(char channel){
  sound_set(13, 0);
  sound_set(8+channel,0x10);
}

void main_draw_life(char life1, char life2){
  int i;
  
  gotoxy(2,2);
  for (i=0;i<18;i++){
    putchar((i<life1)?128:' ');
  }
  
  gotoxy(2,23);
  for (i=0;i<18;i++){
    putchar((i<life2)?128:' ');    
  }
  
  if (life1<=0 || life2<=0){
    if (life1>0){ gotoxy(18, 2); printf("WINNER!"); }
    if (life2>0){ gotoxy(18,23); printf("WINNER!"); }
    if ( life1==0 && life2==0 ){
      gotoxy(18,23); printf("A DRAW");
      gotoxy(18, 2); printf("A DRAW");
    }
    
    for (i=0;i<50*5;i++){ wait_retrace(); } // wait about 5 secs
  }

}

void main_print_points(int points1, int points2){
    /* put starship sprites for score */
    screen1_sprite_put(2+0,160,132,6);
    screen1_sprite_put(2+1,160,132,15);
    screen1_sprite_put(0+0,216,132,10);
    screen1_sprite_put(0+1,216,132,12);

    /* print total score (battles won by starship) */
    gotoxy(21,14); puts("\200 Score \200");
    gotoxy(21,16); puts("             ");
    gotoxy(21+((points1<100)?1:0),16); printf("%d", points1);
    gotoxy(28+((points2<100)?1:0),16); printf("%d", points2);
}

